package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait CachePolicyQueryStringBehavior {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior
}
object CachePolicyQueryStringBehavior {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior
  ): zio.aws.cloudfront.model.CachePolicyQueryStringBehavior = value match {
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.WHITELIST =>
      val r = whitelist
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.ALL_EXCEPT =>
      val r = allExcept
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.ALL =>
      val r = all
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.CachePolicyQueryStringBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object none
      extends zio.aws.cloudfront.model.CachePolicyQueryStringBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.NONE
  }
  case object whitelist
      extends zio.aws.cloudfront.model.CachePolicyQueryStringBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.WHITELIST
  }
  case object allExcept
      extends zio.aws.cloudfront.model.CachePolicyQueryStringBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.ALL_EXCEPT
  }
  case object all
      extends zio.aws.cloudfront.model.CachePolicyQueryStringBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringBehavior.ALL
  }
}
