package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOriginAccessControlsResponse(
    originAccessControlList: Optional[
      zio.aws.cloudfront.model.OriginAccessControlList
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse = {
    import ListOriginAccessControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse
      .builder()
      .optionallyWith(
        originAccessControlList.map(value => value.buildAwsValue())
      )(_.originAccessControlList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListOriginAccessControlsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListOriginAccessControlsResponse
      .wrap(buildAwsValue())
}
object ListOriginAccessControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListOriginAccessControlsResponse =
      zio.aws.cloudfront.model.ListOriginAccessControlsResponse(
        originAccessControlList.map(value => value.asEditable)
      )
    def originAccessControlList
        : Optional[zio.aws.cloudfront.model.OriginAccessControlList.ReadOnly]
    def getOriginAccessControlList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginAccessControlList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "originAccessControlList",
      originAccessControlList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse
  ) extends zio.aws.cloudfront.model.ListOriginAccessControlsResponse.ReadOnly {
    override val originAccessControlList
        : Optional[zio.aws.cloudfront.model.OriginAccessControlList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originAccessControlList())
        .map(value =>
          zio.aws.cloudfront.model.OriginAccessControlList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse
  ): zio.aws.cloudfront.model.ListOriginAccessControlsResponse.ReadOnly =
    new Wrapper(impl)
}
