package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait OriginRequestPolicyHeaderBehavior {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior
}
object OriginRequestPolicyHeaderBehavior {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior
  ): zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior = value match {
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.WHITELIST =>
      val r = whitelist
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.ALL_VIEWER =>
      val r = allViewer
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.ALL_VIEWER_AND_WHITELIST_CLOUD_FRONT =>
      val r = allViewerAndWhitelistCloudFront
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.ALL_EXCEPT =>
      val r = allExcept
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object none
      extends zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.NONE
  }
  case object whitelist
      extends zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.WHITELIST
  }
  case object allViewer
      extends zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.ALL_VIEWER
  }
  case object allViewerAndWhitelistCloudFront
      extends zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.ALL_VIEWER_AND_WHITELIST_CLOUD_FRONT
  }
  case object allExcept
      extends zio.aws.cloudfront.model.OriginRequestPolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyHeaderBehavior.ALL_EXCEPT
  }
}
