package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PublishFunctionRequest(name: String, ifMatch: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest = {
    import PublishFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest
      .builder()
      .name(name: java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.PublishFunctionRequest.ReadOnly =
    zio.aws.cloudfront.model.PublishFunctionRequest.wrap(buildAwsValue())
}
object PublishFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.PublishFunctionRequest =
      zio.aws.cloudfront.model.PublishFunctionRequest(name, ifMatch)
    def name: String
    def ifMatch: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest
  ) extends zio.aws.cloudfront.model.PublishFunctionRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest
  ): zio.aws.cloudfront.model.PublishFunctionRequest.ReadOnly = new Wrapper(
    impl
  )
}
