package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetOriginAccessControlConfigResponse(
    originAccessControlConfig: Optional[
      zio.aws.cloudfront.model.OriginAccessControlConfig
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse = {
    import GetOriginAccessControlConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse
      .builder()
      .optionallyWith(
        originAccessControlConfig.map(value => value.buildAwsValue())
      )(_.originAccessControlConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse
      .wrap(buildAwsValue())
}
object GetOriginAccessControlConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse =
      zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse(
        originAccessControlConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def originAccessControlConfig
        : Optional[zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly]
    def eTag: Optional[String]
    def getOriginAccessControlConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "originAccessControlConfig",
      originAccessControlConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse
  ) extends zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.ReadOnly {
    override val originAccessControlConfig: Optional[
      zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originAccessControlConfig())
      .map(value =>
        zio.aws.cloudfront.model.OriginAccessControlConfig.wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse
  ): zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.ReadOnly =
    new Wrapper(impl)
}
