package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRealtimeLogConfigResponse(
    realtimeLogConfig: Optional[zio.aws.cloudfront.model.RealtimeLogConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse = {
    import CreateRealtimeLogConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse
      .builder()
      .optionallyWith(realtimeLogConfig.map(value => value.buildAwsValue()))(
        _.realtimeLogConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse
      .wrap(buildAwsValue())
}
object CreateRealtimeLogConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse =
      zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse(
        realtimeLogConfig.map(value => value.asEditable)
      )
    def realtimeLogConfig
        : Optional[zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly]
    def getRealtimeLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("realtimeLogConfig", realtimeLogConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse
  ) extends zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.ReadOnly {
    override val realtimeLogConfig
        : Optional[zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.realtimeLogConfig())
        .map(value => zio.aws.cloudfront.model.RealtimeLogConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse
  ): zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.ReadOnly =
    new Wrapper(impl)
}
