package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.{Integer, Timestamp}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Distribution(
    id: String,
    arn: String,
    status: String,
    lastModifiedTime: Timestamp,
    inProgressInvalidationBatches: Integer,
    domainName: String,
    activeTrustedSigners: Optional[
      zio.aws.cloudfront.model.ActiveTrustedSigners
    ] = Optional.Absent,
    activeTrustedKeyGroups: Optional[
      zio.aws.cloudfront.model.ActiveTrustedKeyGroups
    ] = Optional.Absent,
    distributionConfig: zio.aws.cloudfront.model.DistributionConfig,
    aliasICPRecordals: Optional[
      Iterable[zio.aws.cloudfront.model.AliasICPRecordal]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Distribution = {
    import Distribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Distribution
      .builder()
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .status(status: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .inProgressInvalidationBatches(
        inProgressInvalidationBatches: java.lang.Integer
      )
      .domainName(domainName: java.lang.String)
      .optionallyWith(activeTrustedSigners.map(value => value.buildAwsValue()))(
        _.activeTrustedSigners
      )
      .optionallyWith(
        activeTrustedKeyGroups.map(value => value.buildAwsValue())
      )(_.activeTrustedKeyGroups)
      .distributionConfig(distributionConfig.buildAwsValue())
      .optionallyWith(
        aliasICPRecordals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliasICPRecordals)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Distribution.ReadOnly =
    zio.aws.cloudfront.model.Distribution.wrap(buildAwsValue())
}
object Distribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.Distribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Distribution =
      zio.aws.cloudfront.model.Distribution(
        id,
        arn,
        status,
        lastModifiedTime,
        inProgressInvalidationBatches,
        domainName,
        activeTrustedSigners.map(value => value.asEditable),
        activeTrustedKeyGroups.map(value => value.asEditable),
        distributionConfig.asEditable,
        aliasICPRecordals.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: String
    def arn: String
    def status: String
    def lastModifiedTime: Timestamp
    def inProgressInvalidationBatches: Integer
    def domainName: String
    def activeTrustedSigners
        : Optional[zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly]
    def activeTrustedKeyGroups
        : Optional[zio.aws.cloudfront.model.ActiveTrustedKeyGroups.ReadOnly]
    def distributionConfig: zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    def aliasICPRecordals
        : Optional[List[zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly]]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getInProgressInvalidationBatches: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(inProgressInvalidationBatches)
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getActiveTrustedSigners: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly
    ] = AwsError.unwrapOptionField("activeTrustedSigners", activeTrustedSigners)
    def getActiveTrustedKeyGroups: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ActiveTrustedKeyGroups.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeTrustedKeyGroups",
      activeTrustedKeyGroups
    )
    def getDistributionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    ] = ZIO.succeed(distributionConfig)
    def getAliasICPRecordals: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly
    ]] = AwsError.unwrapOptionField("aliasICPRecordals", aliasICPRecordals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Distribution
  ) extends zio.aws.cloudfront.model.Distribution.ReadOnly {
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val status: String = impl.status(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val inProgressInvalidationBatches: Integer =
      impl.inProgressInvalidationBatches(): Integer
    override val domainName: String = impl.domainName(): String
    override val activeTrustedSigners
        : Optional[zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeTrustedSigners())
        .map(value => zio.aws.cloudfront.model.ActiveTrustedSigners.wrap(value))
    override val activeTrustedKeyGroups
        : Optional[zio.aws.cloudfront.model.ActiveTrustedKeyGroups.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeTrustedKeyGroups())
        .map(value =>
          zio.aws.cloudfront.model.ActiveTrustedKeyGroups.wrap(value)
        )
    override val distributionConfig
        : zio.aws.cloudfront.model.DistributionConfig.ReadOnly =
      zio.aws.cloudfront.model.DistributionConfig
        .wrap(impl.distributionConfig())
    override val aliasICPRecordals
        : Optional[List[zio.aws.cloudfront.model.AliasICPRecordal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliasICPRecordals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.AliasICPRecordal.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Distribution
  ): zio.aws.cloudfront.model.Distribution.ReadOnly = new Wrapper(impl)
}
