package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyXSSProtection(
    `override`: Boolean,
    protection: Boolean,
    modeBlock: Optional[Boolean] = Optional.Absent,
    reportUri: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyXSSProtection = {
    import ResponseHeadersPolicyXSSProtection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyXSSProtection
      .builder()
      .`override`(`override`: java.lang.Boolean)
      .protection(protection: java.lang.Boolean)
      .optionallyWith(modeBlock.map(value => value: java.lang.Boolean))(
        _.modeBlock
      )
      .optionallyWith(reportUri.map(value => value: java.lang.String))(
        _.reportUri
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyXSSProtection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyXSSProtection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection =
      zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection(
        `override`,
        protection,
        modeBlock.map(value => value),
        reportUri.map(value => value)
      )
    def `override`: Boolean
    def protection: Boolean
    def modeBlock: Optional[Boolean]
    def reportUri: Optional[String]
    def getOverride: ZIO[Any, Nothing, Boolean] = ZIO.succeed(`override`)
    def getProtection: ZIO[Any, Nothing, Boolean] = ZIO.succeed(protection)
    def getModeBlock: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("modeBlock", modeBlock)
    def getReportUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reportUri", reportUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyXSSProtection
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection.ReadOnly {
    override val `override`: Boolean = impl.`override`(): Boolean
    override val protection: Boolean = impl.protection(): Boolean
    override val modeBlock: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.modeBlock())
      .map(value => value: Boolean)
    override val reportUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reportUri())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyXSSProtection
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyXSSProtection.ReadOnly =
    new Wrapper(impl)
}
