package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyRemoveHeadersConfig(
    quantity: Integer,
    items: Optional[
      Iterable[zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeader]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig = {
    import ResponseHeadersPolicyRemoveHeadersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyRemoveHeadersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig =
      zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items: Optional[
      List[zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeader.ReadOnly]
    ]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Optional[
      List[zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeader.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeader.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeadersConfig.ReadOnly =
    new Wrapper(impl)
}
