package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFunctionsRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent,
    stage: Optional[zio.aws.cloudfront.model.FunctionStage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest = {
    import ListFunctionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListFunctionsRequest.ReadOnly =
    zio.aws.cloudfront.model.ListFunctionsRequest.wrap(buildAwsValue())
}
object ListFunctionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListFunctionsRequest =
      zio.aws.cloudfront.model.ListFunctionsRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        stage.map(value => value)
      )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def stage: Optional[zio.aws.cloudfront.model.FunctionStage]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getStage: ZIO[Any, AwsError, zio.aws.cloudfront.model.FunctionStage] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest
  ) extends zio.aws.cloudfront.model.ListFunctionsRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
    override val stage: Optional[zio.aws.cloudfront.model.FunctionStage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.cloudfront.model.FunctionStage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest
  ): zio.aws.cloudfront.model.ListFunctionsRequest.ReadOnly = new Wrapper(impl)
}
