package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStreamingDistributionResponse(
    streamingDistribution: Optional[
      zio.aws.cloudfront.model.StreamingDistribution
    ] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse = {
    import CreateStreamingDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse
      .builder()
      .optionallyWith(
        streamingDistribution.map(value => value.buildAwsValue())
      )(_.streamingDistribution)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateStreamingDistributionResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateStreamingDistributionResponse
      .wrap(buildAwsValue())
}
object CreateStreamingDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateStreamingDistributionResponse =
      zio.aws.cloudfront.model.CreateStreamingDistributionResponse(
        streamingDistribution.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def streamingDistribution
        : Optional[zio.aws.cloudfront.model.StreamingDistribution.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getStreamingDistribution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.StreamingDistribution.ReadOnly
    ] =
      AwsError.unwrapOptionField("streamingDistribution", streamingDistribution)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse
  ) extends zio.aws.cloudfront.model.CreateStreamingDistributionResponse.ReadOnly {
    override val streamingDistribution
        : Optional[zio.aws.cloudfront.model.StreamingDistribution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingDistribution())
        .map(value =>
          zio.aws.cloudfront.model.StreamingDistribution.wrap(value)
        )
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse
  ): zio.aws.cloudfront.model.CreateStreamingDistributionResponse.ReadOnly =
    new Wrapper(impl)
}
