package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFieldLevelEncryptionProfileConfigResponse(
    fieldLevelEncryptionProfileConfig: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse = {
    import GetFieldLevelEncryptionProfileConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse
      .builder()
      .optionallyWith(
        fieldLevelEncryptionProfileConfig.map(value => value.buildAwsValue())
      )(_.fieldLevelEncryptionProfileConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse
      .wrap(buildAwsValue())
}
object GetFieldLevelEncryptionProfileConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse =
      zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse(
        fieldLevelEncryptionProfileConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def fieldLevelEncryptionProfileConfig: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly
    ]
    def eTag: Optional[String]
    def getFieldLevelEncryptionProfileConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fieldLevelEncryptionProfileConfig",
      fieldLevelEncryptionProfileConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse
  ) extends zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.ReadOnly {
    override val fieldLevelEncryptionProfileConfig: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldLevelEncryptionProfileConfig())
      .map(value =>
        zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse
  ): zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.ReadOnly =
    new Wrapper(impl)
}
