package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteOriginRequestPolicyRequest(
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest = {
    import DeleteOriginRequestPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteOriginRequestPolicyRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteOriginRequestPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteOriginRequestPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteOriginRequestPolicyRequest =
      zio.aws.cloudfront.model
        .DeleteOriginRequestPolicyRequest(id, ifMatch.map(value => value))
    def id: String
    def ifMatch: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest
  ) extends zio.aws.cloudfront.model.DeleteOriginRequestPolicyRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest
  ): zio.aws.cloudfront.model.DeleteOriginRequestPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
