package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetInvalidationRequest(distributionId: String, id: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest = {
    import GetInvalidationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest
      .builder()
      .distributionId(distributionId: java.lang.String)
      .id(id: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetInvalidationRequest.ReadOnly =
    zio.aws.cloudfront.model.GetInvalidationRequest.wrap(buildAwsValue())
}
object GetInvalidationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetInvalidationRequest =
      zio.aws.cloudfront.model.GetInvalidationRequest(distributionId, id)
    def distributionId: String
    def id: String
    def getDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionId)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest
  ) extends zio.aws.cloudfront.model.GetInvalidationRequest.ReadOnly {
    override val distributionId: String = impl.distributionId(): String
    override val id: String = impl.id(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest
  ): zio.aws.cloudfront.model.GetInvalidationRequest.ReadOnly = new Wrapper(
    impl
  )
}
