package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStreamingDistributionRequest(
    streamingDistributionConfig: zio.aws.cloudfront.model.StreamingDistributionConfig,
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest = {
    import UpdateStreamingDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest
      .builder()
      .streamingDistributionConfig(streamingDistributionConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateStreamingDistributionRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateStreamingDistributionRequest
      .wrap(buildAwsValue())
}
object UpdateStreamingDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateStreamingDistributionRequest =
      zio.aws.cloudfront.model.UpdateStreamingDistributionRequest(
        streamingDistributionConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def streamingDistributionConfig
        : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    def id: String
    def ifMatch: Optional[String]
    def getStreamingDistributionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    ] = ZIO.succeed(streamingDistributionConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest
  ) extends zio.aws.cloudfront.model.UpdateStreamingDistributionRequest.ReadOnly {
    override val streamingDistributionConfig
        : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly =
      zio.aws.cloudfront.model.StreamingDistributionConfig
        .wrap(impl.streamingDistributionConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest
  ): zio.aws.cloudfront.model.UpdateStreamingDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
