package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCloudFrontOriginAccessIdentityRequest(id: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest = {
    import GetCloudFrontOriginAccessIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest
      .builder()
      .id(id: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest.ReadOnly =
    zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest
      .wrap(buildAwsValue())
}
object GetCloudFrontOriginAccessIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest =
      zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest(id)
    def id: String
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest
  ) extends zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest.ReadOnly {
    override val id: String = impl.id(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest
  ): zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
