package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateOriginAccessControlResponse(
    originAccessControl: Optional[
      zio.aws.cloudfront.model.OriginAccessControl
    ] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse = {
    import CreateOriginAccessControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse
      .builder()
      .optionallyWith(originAccessControl.map(value => value.buildAwsValue()))(
        _.originAccessControl
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateOriginAccessControlResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateOriginAccessControlResponse
      .wrap(buildAwsValue())
}
object CreateOriginAccessControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateOriginAccessControlResponse =
      zio.aws.cloudfront.model.CreateOriginAccessControlResponse(
        originAccessControl.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def originAccessControl
        : Optional[zio.aws.cloudfront.model.OriginAccessControl.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getOriginAccessControl: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginAccessControl.ReadOnly
    ] = AwsError.unwrapOptionField("originAccessControl", originAccessControl)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse
  ) extends zio.aws.cloudfront.model.CreateOriginAccessControlResponse.ReadOnly {
    override val originAccessControl
        : Optional[zio.aws.cloudfront.model.OriginAccessControl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originAccessControl())
        .map(value => zio.aws.cloudfront.model.OriginAccessControl.wrap(value))
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse
  ): zio.aws.cloudfront.model.CreateOriginAccessControlResponse.ReadOnly =
    new Wrapper(impl)
}
