package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContinuousDeploymentSingleWeightConfig(
    weight: Float,
    sessionStickinessConfig: Optional[
      zio.aws.cloudfront.model.SessionStickinessConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleWeightConfig = {
    import ContinuousDeploymentSingleWeightConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleWeightConfig
      .builder()
      .weight(weight: java.lang.Float)
      .optionallyWith(
        sessionStickinessConfig.map(value => value.buildAwsValue())
      )(_.sessionStickinessConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig.ReadOnly =
    zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig
      .wrap(buildAwsValue())
}
object ContinuousDeploymentSingleWeightConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleWeightConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig =
      zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig(
        weight,
        sessionStickinessConfig.map(value => value.asEditable)
      )
    def weight: Float
    def sessionStickinessConfig
        : Optional[zio.aws.cloudfront.model.SessionStickinessConfig.ReadOnly]
    def getWeight: ZIO[Any, Nothing, Float] = ZIO.succeed(weight)
    def getSessionStickinessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.SessionStickinessConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sessionStickinessConfig",
      sessionStickinessConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleWeightConfig
  ) extends zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig.ReadOnly {
    override val weight: Float = impl.weight(): Float
    override val sessionStickinessConfig
        : Optional[zio.aws.cloudfront.model.SessionStickinessConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionStickinessConfig())
        .map(value =>
          zio.aws.cloudfront.model.SessionStickinessConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleWeightConfig
  ): zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig.ReadOnly =
    new Wrapper(impl)
}
