package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFieldLevelEncryptionConfigResponse(
    fieldLevelEncryption: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryption
    ] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse = {
    import CreateFieldLevelEncryptionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
      .builder()
      .optionallyWith(fieldLevelEncryption.map(value => value.buildAwsValue()))(
        _.fieldLevelEncryption
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
      .wrap(buildAwsValue())
}
object CreateFieldLevelEncryptionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse =
      zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse(
        fieldLevelEncryption.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def fieldLevelEncryption
        : Optional[zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getFieldLevelEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("fieldLevelEncryption", fieldLevelEncryption)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
  ) extends zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly {
    override val fieldLevelEncryption
        : Optional[zio.aws.cloudfront.model.FieldLevelEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fieldLevelEncryption())
        .map(value => zio.aws.cloudfront.model.FieldLevelEncryption.wrap(value))
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse
  ): zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly =
    new Wrapper(impl)
}
