package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActiveTrustedSigners(
    enabled: Boolean,
    quantity: Integer,
    items: Optional[Iterable[zio.aws.cloudfront.model.Signer]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners = {
    import ActiveTrustedSigners.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly =
    zio.aws.cloudfront.model.ActiveTrustedSigners.wrap(buildAwsValue())
}
object ActiveTrustedSigners {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ActiveTrustedSigners =
      zio.aws.cloudfront.model.ActiveTrustedSigners(
        enabled,
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enabled: Boolean
    def quantity: Integer
    def items: Optional[List[zio.aws.cloudfront.model.Signer.ReadOnly]]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.cloudfront.model.Signer.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners
  ) extends zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val quantity: Integer = impl.quantity(): Integer
    override val items
        : Optional[List[zio.aws.cloudfront.model.Signer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.Signer.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners
  ): zio.aws.cloudfront.model.ActiveTrustedSigners.ReadOnly = new Wrapper(impl)
}
