package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCachePoliciesResponse(
    cachePolicyList: Optional[zio.aws.cloudfront.model.CachePolicyList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse = {
    import ListCachePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse
      .builder()
      .optionallyWith(cachePolicyList.map(value => value.buildAwsValue()))(
        _.cachePolicyList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListCachePoliciesResponse.ReadOnly =
    zio.aws.cloudfront.model.ListCachePoliciesResponse.wrap(buildAwsValue())
}
object ListCachePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListCachePoliciesResponse =
      zio.aws.cloudfront.model.ListCachePoliciesResponse(
        cachePolicyList.map(value => value.asEditable)
      )
    def cachePolicyList
        : Optional[zio.aws.cloudfront.model.CachePolicyList.ReadOnly]
    def getCachePolicyList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CachePolicyList.ReadOnly
    ] = AwsError.unwrapOptionField("cachePolicyList", cachePolicyList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse
  ) extends zio.aws.cloudfront.model.ListCachePoliciesResponse.ReadOnly {
    override val cachePolicyList
        : Optional[zio.aws.cloudfront.model.CachePolicyList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cachePolicyList())
        .map(value => zio.aws.cloudfront.model.CachePolicyList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse
  ): zio.aws.cloudfront.model.ListCachePoliciesResponse.ReadOnly = new Wrapper(
    impl
  )
}
