package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FieldLevelEncryptionProfileSummary(
    id: String,
    lastModifiedTime: Timestamp,
    name: String,
    encryptionEntities: zio.aws.cloudfront.model.EncryptionEntities,
    comment: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSummary = {
    import FieldLevelEncryptionProfileSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSummary
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .name(name: java.lang.String)
      .encryptionEntities(encryptionEntities.buildAwsValue())
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary.ReadOnly =
    zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary
      .wrap(buildAwsValue())
}
object FieldLevelEncryptionProfileSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary =
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary(
        id,
        lastModifiedTime,
        name,
        encryptionEntities.asEditable,
        comment.map(value => value)
      )
    def id: String
    def lastModifiedTime: Timestamp
    def name: String
    def encryptionEntities: zio.aws.cloudfront.model.EncryptionEntities.ReadOnly
    def comment: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getEncryptionEntities: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.EncryptionEntities.ReadOnly
    ] = ZIO.succeed(encryptionEntities)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSummary
  ) extends zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val name: String = impl.name(): String
    override val encryptionEntities
        : zio.aws.cloudfront.model.EncryptionEntities.ReadOnly =
      zio.aws.cloudfront.model.EncryptionEntities
        .wrap(impl.encryptionEntities())
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSummary
  ): zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary.ReadOnly =
    new Wrapper(impl)
}
