package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateInvalidationRequest(
    distributionId: String,
    invalidationBatch: zio.aws.cloudfront.model.InvalidationBatch
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest = {
    import CreateInvalidationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest
      .builder()
      .distributionId(distributionId: java.lang.String)
      .invalidationBatch(invalidationBatch.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateInvalidationRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateInvalidationRequest.wrap(buildAwsValue())
}
object CreateInvalidationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateInvalidationRequest =
      zio.aws.cloudfront.model
        .CreateInvalidationRequest(distributionId, invalidationBatch.asEditable)
    def distributionId: String
    def invalidationBatch: zio.aws.cloudfront.model.InvalidationBatch.ReadOnly
    def getDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionId)
    def getInvalidationBatch: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.InvalidationBatch.ReadOnly
    ] = ZIO.succeed(invalidationBatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest
  ) extends zio.aws.cloudfront.model.CreateInvalidationRequest.ReadOnly {
    override val distributionId: String = impl.distributionId(): String
    override val invalidationBatch
        : zio.aws.cloudfront.model.InvalidationBatch.ReadOnly =
      zio.aws.cloudfront.model.InvalidationBatch.wrap(impl.invalidationBatch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest
  ): zio.aws.cloudfront.model.CreateInvalidationRequest.ReadOnly = new Wrapper(
    impl
  )
}
