package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Aliases(
    quantity: Integer,
    items: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Aliases = {
    import Aliases.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Aliases
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Aliases.ReadOnly =
    zio.aws.cloudfront.model.Aliases.wrap(buildAwsValue())
}
object Aliases {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.Aliases
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Aliases =
      zio.aws.cloudfront.model.Aliases(quantity, items.map(value => value))
    def quantity: Integer
    def items: Optional[List[String]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Aliases
  ) extends zio.aws.cloudfront.model.Aliases.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Aliases
  ): zio.aws.cloudfront.model.Aliases.ReadOnly = new Wrapper(impl)
}
