package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait OriginProtocolPolicy {
  def unwrap
      : software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy
}
object OriginProtocolPolicy {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy
  ): zio.aws.cloudfront.model.OriginProtocolPolicy = value match {
    case software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy.HTTP_ONLY =>
      val r = `http-only`
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy.MATCH_VIEWER =>
      val r = `match-viewer`
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy.HTTPS_ONLY =>
      val r = `https-only`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.OriginProtocolPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy =
      software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object `http-only`
      extends zio.aws.cloudfront.model.OriginProtocolPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy =
      software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy.HTTP_ONLY
  }
  case object `match-viewer`
      extends zio.aws.cloudfront.model.OriginProtocolPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy =
      software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy.MATCH_VIEWER
  }
  case object `https-only`
      extends zio.aws.cloudfront.model.OriginProtocolPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy =
      software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy.HTTPS_ONLY
  }
}
