package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LoggingConfig(
    enabled: Boolean,
    includeCookies: Boolean,
    bucket: String,
    prefix: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.LoggingConfig = {
    import LoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.LoggingConfig
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .includeCookies(includeCookies: java.lang.Boolean)
      .bucket(bucket: java.lang.String)
      .prefix(prefix: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.LoggingConfig.ReadOnly =
    zio.aws.cloudfront.model.LoggingConfig.wrap(buildAwsValue())
}
object LoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.LoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.LoggingConfig =
      zio.aws.cloudfront.model.LoggingConfig(
        enabled,
        includeCookies,
        bucket,
        prefix
      )
    def enabled: Boolean
    def includeCookies: Boolean
    def bucket: String
    def prefix: String
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getIncludeCookies: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(includeCookies)
    def getBucket: ZIO[Any, Nothing, String] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, Nothing, String] = ZIO.succeed(prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.LoggingConfig
  ) extends zio.aws.cloudfront.model.LoggingConfig.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val includeCookies: Boolean = impl.includeCookies(): Boolean
    override val bucket: String = impl.bucket(): String
    override val prefix: String = impl.prefix(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.LoggingConfig
  ): zio.aws.cloudfront.model.LoggingConfig.ReadOnly = new Wrapper(impl)
}
