package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetKeyGroupConfigResponse(
    keyGroupConfig: Optional[zio.aws.cloudfront.model.KeyGroupConfig] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse = {
    import GetKeyGroupConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse
      .builder()
      .optionallyWith(keyGroupConfig.map(value => value.buildAwsValue()))(
        _.keyGroupConfig
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetKeyGroupConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetKeyGroupConfigResponse.wrap(buildAwsValue())
}
object GetKeyGroupConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetKeyGroupConfigResponse =
      zio.aws.cloudfront.model.GetKeyGroupConfigResponse(
        keyGroupConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def keyGroupConfig
        : Optional[zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly]
    def eTag: Optional[String]
    def getKeyGroupConfig
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly] =
      AwsError.unwrapOptionField("keyGroupConfig", keyGroupConfig)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse
  ) extends zio.aws.cloudfront.model.GetKeyGroupConfigResponse.ReadOnly {
    override val keyGroupConfig
        : Optional[zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyGroupConfig())
        .map(value => zio.aws.cloudfront.model.KeyGroupConfig.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse
  ): zio.aws.cloudfront.model.GetKeyGroupConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
