package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateAliasRequest(
    targetDistributionId: String,
    alias: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest = {
    import AssociateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest
      .builder()
      .targetDistributionId(targetDistributionId: java.lang.String)
      .alias(alias: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.AssociateAliasRequest.ReadOnly =
    zio.aws.cloudfront.model.AssociateAliasRequest.wrap(buildAwsValue())
}
object AssociateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.AssociateAliasRequest =
      zio.aws.cloudfront.model
        .AssociateAliasRequest(targetDistributionId, alias)
    def targetDistributionId: String
    def alias: String
    def getTargetDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDistributionId)
    def getAlias: ZIO[Any, Nothing, String] = ZIO.succeed(alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest
  ) extends zio.aws.cloudfront.model.AssociateAliasRequest.ReadOnly {
    override val targetDistributionId: String =
      impl.targetDistributionId(): String
    override val alias: String = impl.alias(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest
  ): zio.aws.cloudfront.model.AssociateAliasRequest.ReadOnly = new Wrapper(impl)
}
