package zio.aws.cloudfront
import zio.aws.cloudfront.model.CreateKeyGroupResponse.ReadOnly
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.cloudfront.model.{
  ListFieldLevelEncryptionProfilesRequest,
  ListDistributionsRequest,
  GetFieldLevelEncryptionProfileConfigRequest,
  CreateDistributionRequest,
  CreateResponseHeadersPolicyRequest,
  CreateOriginRequestPolicyRequest,
  DescribeFunctionRequest,
  CreateFieldLevelEncryptionProfileRequest,
  DeleteCloudFrontOriginAccessIdentityRequest,
  GetCloudFrontOriginAccessIdentityConfigRequest,
  GetMonitoringSubscriptionRequest,
  CreateInvalidationRequest,
  CreateRealtimeLogConfigRequest,
  DeleteDistributionRequest,
  GetFieldLevelEncryptionProfileRequest,
  ListPublicKeysRequest,
  UpdateFieldLevelEncryptionConfigRequest,
  CreateCachePolicyRequest,
  ListInvalidationsRequest,
  GetResponseHeadersPolicyConfigRequest,
  GetFunctionRequest,
  GetRealtimeLogConfigRequest,
  UpdateKeyGroupRequest,
  DeleteFieldLevelEncryptionConfigRequest,
  ListDistributionsByResponseHeadersPolicyIdRequest,
  ListDistributionsByWebAclIdRequest,
  ListDistributionsByOriginRequestPolicyIdRequest,
  DeleteFunctionRequest,
  CreateOriginAccessControlRequest,
  GetOriginRequestPolicyConfigRequest,
  DeletePublicKeyRequest,
  ListDistributionsByCachePolicyIdRequest,
  UpdateOriginAccessControlRequest,
  GetDistributionConfigRequest,
  GetOriginAccessControlConfigRequest,
  ListResponseHeadersPoliciesRequest,
  ListTagsForResourceRequest,
  UpdateRealtimeLogConfigRequest,
  GetCachePolicyRequest,
  GetStreamingDistributionRequest,
  ListOriginAccessControlsRequest,
  GetDistributionRequest,
  AssociateAliasRequest,
  TestFunctionRequest,
  DeleteResponseHeadersPolicyRequest,
  ListStreamingDistributionsRequest,
  ListFieldLevelEncryptionConfigsRequest,
  CreateDistributionWithTagsRequest,
  CreateKeyGroupRequest,
  GetKeyGroupRequest,
  CreateFieldLevelEncryptionConfigRequest,
  GetInvalidationRequest,
  DeleteCachePolicyRequest,
  CreateMonitoringSubscriptionRequest,
  UpdateDistributionRequest,
  CreateFunctionRequest,
  GetCloudFrontOriginAccessIdentityRequest,
  PublishFunctionRequest,
  GetResponseHeadersPolicyRequest,
  CreateStreamingDistributionWithTagsRequest,
  ListFunctionsRequest,
  UntagResourceRequest,
  UpdateResponseHeadersPolicyRequest,
  DeleteOriginRequestPolicyRequest,
  ListRealtimeLogConfigsRequest,
  DeleteFieldLevelEncryptionProfileRequest,
  GetFieldLevelEncryptionRequest,
  UpdateFunctionRequest,
  ListCachePoliciesRequest,
  GetKeyGroupConfigRequest,
  ListConflictingAliasesRequest,
  UpdateCloudFrontOriginAccessIdentityRequest,
  ListCloudFrontOriginAccessIdentitiesRequest,
  UpdateFieldLevelEncryptionProfileRequest,
  GetStreamingDistributionConfigRequest,
  UpdateStreamingDistributionRequest,
  ListOriginRequestPoliciesRequest,
  ListDistributionsByKeyGroupRequest,
  UpdateCachePolicyRequest,
  GetCachePolicyConfigRequest,
  GetOriginRequestPolicyRequest,
  UpdatePublicKeyRequest,
  DeleteKeyGroupRequest,
  ListDistributionsByRealtimeLogConfigRequest,
  GetPublicKeyRequest,
  GetOriginAccessControlRequest,
  GetPublicKeyConfigRequest,
  DeleteStreamingDistributionRequest,
  CreateCloudFrontOriginAccessIdentityRequest,
  ListKeyGroupsRequest,
  DeleteOriginAccessControlRequest,
  GetFieldLevelEncryptionConfigRequest,
  DeleteRealtimeLogConfigRequest,
  TagResourceRequest,
  CreatePublicKeyRequest,
  DeleteMonitoringSubscriptionRequest,
  UpdateOriginRequestPolicyRequest,
  CreateStreamingDistributionRequest
}
object CloudFrontMock extends Mock[CloudFront] {
  object ListResponseHeadersPolicies
      extends Effect[
        ListResponseHeadersPoliciesRequest,
        AwsError,
        zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.ReadOnly
      ]
  object GetInvalidation
      extends Effect[
        GetInvalidationRequest,
        AwsError,
        zio.aws.cloudfront.model.GetInvalidationResponse.ReadOnly
      ]
  object DeleteKeyGroup extends Effect[DeleteKeyGroupRequest, AwsError, Unit]
  object UpdateOriginAccessControl
      extends Effect[
        UpdateOriginAccessControlRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.ReadOnly
      ]
  object CreateMonitoringSubscription
      extends Effect[
        CreateMonitoringSubscriptionRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.ReadOnly
      ]
  object GetRealtimeLogConfig
      extends Effect[
        GetRealtimeLogConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.ReadOnly
      ]
  object CreateStreamingDistribution
      extends Effect[
        CreateStreamingDistributionRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateStreamingDistributionResponse.ReadOnly
      ]
  object TestFunction
      extends Effect[
        TestFunctionRequest,
        AwsError,
        zio.aws.cloudfront.model.TestFunctionResponse.ReadOnly
      ]
  object GetFieldLevelEncryptionProfile
      extends Effect[
        GetFieldLevelEncryptionProfileRequest,
        AwsError,
        zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.ReadOnly
      ]
  object ListDistributionsByWebACLId
      extends Effect[
        ListDistributionsByWebAclIdRequest,
        AwsError,
        zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.ReadOnly
      ]
  object DeleteCloudFrontOriginAccessIdentity
      extends Effect[
        DeleteCloudFrontOriginAccessIdentityRequest,
        AwsError,
        Unit
      ]
  object CreateRealtimeLogConfig
      extends Effect[
        CreateRealtimeLogConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.ReadOnly
      ]
  object ListPublicKeys
      extends Effect[
        ListPublicKeysRequest,
        AwsError,
        zio.aws.cloudfront.model.ListPublicKeysResponse.ReadOnly
      ]
  object CreateOriginAccessControl
      extends Effect[
        CreateOriginAccessControlRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateOriginAccessControlResponse.ReadOnly
      ]
  object GetKeyGroup
      extends Effect[
        GetKeyGroupRequest,
        AwsError,
        zio.aws.cloudfront.model.GetKeyGroupResponse.ReadOnly
      ]
  object GetOriginAccessControl
      extends Effect[
        GetOriginAccessControlRequest,
        AwsError,
        zio.aws.cloudfront.model.GetOriginAccessControlResponse.ReadOnly
      ]
  object CreateStreamingDistributionWithTags
      extends Effect[
        CreateStreamingDistributionWithTagsRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateStreamingDistributionWithTagsResponse.ReadOnly
      ]
  object ListConflictingAliases
      extends Effect[
        ListConflictingAliasesRequest,
        AwsError,
        zio.aws.cloudfront.model.ListConflictingAliasesResponse.ReadOnly
      ]
  object ListDistributionsByOriginRequestPolicyId
      extends Effect[
        ListDistributionsByOriginRequestPolicyIdRequest,
        AwsError,
        zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse.ReadOnly
      ]
  object DeleteCachePolicy
      extends Effect[DeleteCachePolicyRequest, AwsError, Unit]
  object CreateDistributionWithTags
      extends Effect[
        CreateDistributionWithTagsRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateDistributionWithTagsResponse.ReadOnly
      ]
  object GetFieldLevelEncryptionConfig
      extends Effect[
        GetFieldLevelEncryptionConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.ReadOnly
      ]
  object DeleteOriginAccessControl
      extends Effect[DeleteOriginAccessControlRequest, AwsError, Unit]
  object UpdateRealtimeLogConfig
      extends Effect[
        UpdateRealtimeLogConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.ReadOnly
      ]
  object ListCachePolicies
      extends Effect[
        ListCachePoliciesRequest,
        AwsError,
        zio.aws.cloudfront.model.ListCachePoliciesResponse.ReadOnly
      ]
  object ListFieldLevelEncryptionConfigs
      extends Effect[
        ListFieldLevelEncryptionConfigsRequest,
        AwsError,
        zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.ReadOnly
      ]
  object DeletePublicKey extends Effect[DeletePublicKeyRequest, AwsError, Unit]
  object ListOriginRequestPolicies
      extends Effect[
        ListOriginRequestPoliciesRequest,
        AwsError,
        zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.ReadOnly
      ]
  object ListOriginAccessControls
      extends Effect[
        ListOriginAccessControlsRequest,
        AwsError,
        zio.aws.cloudfront.model.ListOriginAccessControlsResponse.ReadOnly
      ]
  object GetPublicKey
      extends Effect[
        GetPublicKeyRequest,
        AwsError,
        zio.aws.cloudfront.model.GetPublicKeyResponse.ReadOnly
      ]
  object GetStreamingDistribution
      extends Effect[
        GetStreamingDistributionRequest,
        AwsError,
        zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly
      ]
  object UpdateStreamingDistribution
      extends Effect[
        UpdateStreamingDistributionRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.ReadOnly
      ]
  object CreateCachePolicy
      extends Effect[
        CreateCachePolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateCachePolicyResponse.ReadOnly
      ]
  object DeleteFieldLevelEncryptionConfig
      extends Effect[DeleteFieldLevelEncryptionConfigRequest, AwsError, Unit]
  object GetPublicKeyConfig
      extends Effect[
        GetPublicKeyConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly
      ]
  object DescribeFunction
      extends Effect[
        DescribeFunctionRequest,
        AwsError,
        zio.aws.cloudfront.model.DescribeFunctionResponse.ReadOnly
      ]
  object UpdateResponseHeadersPolicy
      extends Effect[
        UpdateResponseHeadersPolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.ReadOnly
      ]
  object ListFieldLevelEncryptionProfiles
      extends Effect[
        ListFieldLevelEncryptionProfilesRequest,
        AwsError,
        zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.ReadOnly
      ]
  object GetOriginRequestPolicy
      extends Effect[
        GetOriginRequestPolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly
      ]
  object DeleteFunction extends Effect[DeleteFunctionRequest, AwsError, Unit]
  object CreateFieldLevelEncryptionConfig
      extends Effect[
        CreateFieldLevelEncryptionConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly
      ]
  object GetFieldLevelEncryptionProfileConfig
      extends Effect[
        GetFieldLevelEncryptionProfileConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.ReadOnly
      ]
  object GetCloudFrontOriginAccessIdentity
      extends Effect[
        GetCloudFrontOriginAccessIdentityRequest,
        AwsError,
        zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.ReadOnly
      ]
  object CreateKeyGroup
      extends Effect[CreateKeyGroupRequest, AwsError, ReadOnly]
  object GetMonitoringSubscription
      extends Effect[
        GetMonitoringSubscriptionRequest,
        AwsError,
        zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.ReadOnly
      ]
  object ListDistributions
      extends Effect[
        ListDistributionsRequest,
        AwsError,
        zio.aws.cloudfront.model.ListDistributionsResponse.ReadOnly
      ]
  object DeleteStreamingDistribution
      extends Effect[DeleteStreamingDistributionRequest, AwsError, Unit]
  object ListStreamingDistributions
      extends Effect[
        ListStreamingDistributionsRequest,
        AwsError,
        zio.aws.cloudfront.model.ListStreamingDistributionsResponse.ReadOnly
      ]
  object ListRealtimeLogConfigs
      extends Effect[
        ListRealtimeLogConfigsRequest,
        AwsError,
        zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DeleteOriginRequestPolicy
      extends Effect[DeleteOriginRequestPolicyRequest, AwsError, Unit]
  object DeleteRealtimeLogConfig
      extends Effect[DeleteRealtimeLogConfigRequest, AwsError, Unit]
  object DeleteResponseHeadersPolicy
      extends Effect[DeleteResponseHeadersPolicyRequest, AwsError, Unit]
  object UpdateFunction
      extends Effect[
        UpdateFunctionRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateFunctionResponse.ReadOnly
      ]
  object CreateInvalidation
      extends Effect[
        CreateInvalidationRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateInvalidationResponse.ReadOnly
      ]
  object ListDistributionsByRealtimeLogConfig
      extends Effect[
        ListDistributionsByRealtimeLogConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse.ReadOnly
      ]
  object GetResponseHeadersPolicyConfig
      extends Effect[
        GetResponseHeadersPolicyConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.ReadOnly
      ]
  object GetDistributionConfig
      extends Effect[
        GetDistributionConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetDistributionConfigResponse.ReadOnly
      ]
  object CreatePublicKey
      extends Effect[
        CreatePublicKeyRequest,
        AwsError,
        zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly
      ]
  object UpdateKeyGroup
      extends Effect[
        UpdateKeyGroupRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateKeyGroupResponse.ReadOnly
      ]
  object UpdateOriginRequestPolicy
      extends Effect[
        UpdateOriginRequestPolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly
      ]
  object CreateCloudFrontOriginAccessIdentity
      extends Effect[
        CreateCloudFrontOriginAccessIdentityRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.ReadOnly
      ]
  object AssociateAlias extends Effect[AssociateAliasRequest, AwsError, Unit]
  object UpdatePublicKey
      extends Effect[
        UpdatePublicKeyRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdatePublicKeyResponse.ReadOnly
      ]
  object ListDistributionsByCachePolicyId
      extends Effect[
        ListDistributionsByCachePolicyIdRequest,
        AwsError,
        zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.ReadOnly
      ]
  object GetCloudFrontOriginAccessIdentityConfig
      extends Effect[
        GetCloudFrontOriginAccessIdentityConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.cloudfront.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetCachePolicyConfig
      extends Effect[
        GetCachePolicyConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetCachePolicyConfigResponse.ReadOnly
      ]
  object ListKeyGroups
      extends Effect[
        ListKeyGroupsRequest,
        AwsError,
        zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly
      ]
  object GetFieldLevelEncryption
      extends Effect[
        GetFieldLevelEncryptionRequest,
        AwsError,
        zio.aws.cloudfront.model.GetFieldLevelEncryptionResponse.ReadOnly
      ]
  object PublishFunction
      extends Effect[
        PublishFunctionRequest,
        AwsError,
        zio.aws.cloudfront.model.PublishFunctionResponse.ReadOnly
      ]
  object CreateOriginRequestPolicy
      extends Effect[
        CreateOriginRequestPolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DeleteMonitoringSubscription
      extends Effect[
        DeleteMonitoringSubscriptionRequest,
        AwsError,
        zio.aws.cloudfront.model.DeleteMonitoringSubscriptionResponse.ReadOnly
      ]
  object GetStreamingDistributionConfig
      extends Effect[
        GetStreamingDistributionConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.ReadOnly
      ]
  object UpdateFieldLevelEncryptionProfile
      extends Effect[
        UpdateFieldLevelEncryptionProfileRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.ReadOnly
      ]
  object CreateFieldLevelEncryptionProfile
      extends Effect[
        CreateFieldLevelEncryptionProfileRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly
      ]
  object ListFunctions
      extends Effect[
        ListFunctionsRequest,
        AwsError,
        zio.aws.cloudfront.model.ListFunctionsResponse.ReadOnly
      ]
  object DeleteFieldLevelEncryptionProfile
      extends Effect[DeleteFieldLevelEncryptionProfileRequest, AwsError, Unit]
  object GetResponseHeadersPolicy
      extends Effect[
        GetResponseHeadersPolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly
      ]
  object ListInvalidations
      extends Effect[
        ListInvalidationsRequest,
        AwsError,
        zio.aws.cloudfront.model.ListInvalidationsResponse.ReadOnly
      ]
  object CreateResponseHeadersPolicy
      extends Effect[
        CreateResponseHeadersPolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.ReadOnly
      ]
  object GetKeyGroupConfig
      extends Effect[
        GetKeyGroupConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetKeyGroupConfigResponse.ReadOnly
      ]
  object UpdateCloudFrontOriginAccessIdentity
      extends Effect[
        UpdateCloudFrontOriginAccessIdentityRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.ReadOnly
      ]
  object ListDistributionsByResponseHeadersPolicyId
      extends Effect[
        ListDistributionsByResponseHeadersPolicyIdRequest,
        AwsError,
        zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse.ReadOnly
      ]
  object UpdateCachePolicy
      extends Effect[
        UpdateCachePolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateCachePolicyResponse.ReadOnly
      ]
  object CreateFunction
      extends Effect[
        CreateFunctionRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateFunctionResponse.ReadOnly
      ]
  object GetOriginAccessControlConfig
      extends Effect[
        GetOriginAccessControlConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.ReadOnly
      ]
  object GetCachePolicy
      extends Effect[
        GetCachePolicyRequest,
        AwsError,
        zio.aws.cloudfront.model.GetCachePolicyResponse.ReadOnly
      ]
  object GetDistribution
      extends Effect[
        GetDistributionRequest,
        AwsError,
        zio.aws.cloudfront.model.GetDistributionResponse.ReadOnly
      ]
  object GetOriginRequestPolicyConfig
      extends Effect[
        GetOriginRequestPolicyConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.ReadOnly
      ]
  object ListCloudFrontOriginAccessIdentities
      extends Effect[
        ListCloudFrontOriginAccessIdentitiesRequest,
        AwsError,
        zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.ReadOnly
      ]
  object UpdateDistribution
      extends Effect[
        UpdateDistributionRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateDistributionResponse.ReadOnly
      ]
  object GetFunction
      extends Effect[
        GetFunctionRequest,
        AwsError,
        zio.aws.cloudfront.model.GetFunctionResponse.ReadOnly
      ]
  object DeleteDistribution
      extends Effect[DeleteDistributionRequest, AwsError, Unit]
  object UpdateFieldLevelEncryptionConfig
      extends Effect[
        UpdateFieldLevelEncryptionConfigRequest,
        AwsError,
        zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.ReadOnly
      ]
  object ListDistributionsByKeyGroup
      extends Effect[
        ListDistributionsByKeyGroupRequest,
        AwsError,
        zio.aws.cloudfront.model.ListDistributionsByKeyGroupResponse.ReadOnly
      ]
  object CreateDistribution
      extends Effect[
        CreateDistributionRequest,
        AwsError,
        zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CloudFront] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CloudFront] { rts =>
        zio.ZIO.succeed {
          new CloudFront {
            val api: CloudFrontAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CloudFront = this
            def listResponseHeadersPolicies(
                request: ListResponseHeadersPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListResponseHeadersPoliciesResponse.ReadOnly
            ] = proxy(ListResponseHeadersPolicies, request)
            def getInvalidation(request: GetInvalidationRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetInvalidationResponse.ReadOnly
            ] = proxy(GetInvalidation, request)
            def deleteKeyGroup(
                request: DeleteKeyGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteKeyGroup, request)
            def updateOriginAccessControl(
                request: UpdateOriginAccessControlRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.ReadOnly
            ] = proxy(UpdateOriginAccessControl, request)
            def createMonitoringSubscription(
                request: CreateMonitoringSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateMonitoringSubscriptionResponse.ReadOnly
            ] = proxy(CreateMonitoringSubscription, request)
            def getRealtimeLogConfig(request: GetRealtimeLogConfigRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.ReadOnly
            ] = proxy(GetRealtimeLogConfig, request)
            def createStreamingDistribution(
                request: CreateStreamingDistributionRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateStreamingDistributionResponse.ReadOnly
            ] = proxy(CreateStreamingDistribution, request)
            def testFunction(request: TestFunctionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.TestFunctionResponse.ReadOnly
            ] = proxy(TestFunction, request)
            def getFieldLevelEncryptionProfile(
                request: GetFieldLevelEncryptionProfileRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.ReadOnly
            ] = proxy(GetFieldLevelEncryptionProfile, request)
            def listDistributionsByWebACLId(
                request: ListDistributionsByWebAclIdRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListDistributionsByWebAclIdResponse.ReadOnly
            ] = proxy(ListDistributionsByWebACLId, request)
            def deleteCloudFrontOriginAccessIdentity(
                request: DeleteCloudFrontOriginAccessIdentityRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteCloudFrontOriginAccessIdentity, request)
            def createRealtimeLogConfig(
                request: CreateRealtimeLogConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateRealtimeLogConfigResponse.ReadOnly
            ] = proxy(CreateRealtimeLogConfig, request)
            def listPublicKeys(request: ListPublicKeysRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.ListPublicKeysResponse.ReadOnly
            ] = proxy(ListPublicKeys, request)
            def createOriginAccessControl(
                request: CreateOriginAccessControlRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateOriginAccessControlResponse.ReadOnly
            ] = proxy(CreateOriginAccessControl, request)
            def getKeyGroup(request: GetKeyGroupRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetKeyGroupResponse.ReadOnly
            ] = proxy(GetKeyGroup, request)
            def getOriginAccessControl(
                request: GetOriginAccessControlRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetOriginAccessControlResponse.ReadOnly
            ] = proxy(GetOriginAccessControl, request)
            def createStreamingDistributionWithTags(
                request: CreateStreamingDistributionWithTagsRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateStreamingDistributionWithTagsResponse.ReadOnly
            ] = proxy(CreateStreamingDistributionWithTags, request)
            def listConflictingAliases(
                request: ListConflictingAliasesRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListConflictingAliasesResponse.ReadOnly
            ] = proxy(ListConflictingAliases, request)
            def listDistributionsByOriginRequestPolicyId(
                request: ListDistributionsByOriginRequestPolicyIdRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse.ReadOnly
            ] = proxy(ListDistributionsByOriginRequestPolicyId, request)
            def deleteCachePolicy(
                request: DeleteCachePolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteCachePolicy, request)
            def createDistributionWithTags(
                request: CreateDistributionWithTagsRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateDistributionWithTagsResponse.ReadOnly
            ] = proxy(CreateDistributionWithTags, request)
            def getFieldLevelEncryptionConfig(
                request: GetFieldLevelEncryptionConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetFieldLevelEncryptionConfigResponse.ReadOnly
            ] = proxy(GetFieldLevelEncryptionConfig, request)
            def deleteOriginAccessControl(
                request: DeleteOriginAccessControlRequest
            ): IO[AwsError, Unit] = proxy(DeleteOriginAccessControl, request)
            def updateRealtimeLogConfig(
                request: UpdateRealtimeLogConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateRealtimeLogConfigResponse.ReadOnly
            ] = proxy(UpdateRealtimeLogConfig, request)
            def listCachePolicies(request: ListCachePoliciesRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.ListCachePoliciesResponse.ReadOnly
            ] = proxy(ListCachePolicies, request)
            def listFieldLevelEncryptionConfigs(
                request: ListFieldLevelEncryptionConfigsRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListFieldLevelEncryptionConfigsResponse.ReadOnly
            ] = proxy(ListFieldLevelEncryptionConfigs, request)
            def deletePublicKey(
                request: DeletePublicKeyRequest
            ): IO[AwsError, Unit] = proxy(DeletePublicKey, request)
            def listOriginRequestPolicies(
                request: ListOriginRequestPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.ReadOnly
            ] = proxy(ListOriginRequestPolicies, request)
            def listOriginAccessControls(
                request: ListOriginAccessControlsRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListOriginAccessControlsResponse.ReadOnly
            ] = proxy(ListOriginAccessControls, request)
            def getPublicKey(request: GetPublicKeyRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetPublicKeyResponse.ReadOnly
            ] = proxy(GetPublicKey, request)
            def getStreamingDistribution(
                request: GetStreamingDistributionRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly
            ] = proxy(GetStreamingDistribution, request)
            def updateStreamingDistribution(
                request: UpdateStreamingDistributionRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.ReadOnly
            ] = proxy(UpdateStreamingDistribution, request)
            def createCachePolicy(request: CreateCachePolicyRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateCachePolicyResponse.ReadOnly
            ] = proxy(CreateCachePolicy, request)
            def deleteFieldLevelEncryptionConfig(
                request: DeleteFieldLevelEncryptionConfigRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteFieldLevelEncryptionConfig, request)
            def getPublicKeyConfig(request: GetPublicKeyConfigRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly
            ] = proxy(GetPublicKeyConfig, request)
            def describeFunction(request: DescribeFunctionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.DescribeFunctionResponse.ReadOnly
            ] = proxy(DescribeFunction, request)
            def updateResponseHeadersPolicy(
                request: UpdateResponseHeadersPolicyRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateResponseHeadersPolicyResponse.ReadOnly
            ] = proxy(UpdateResponseHeadersPolicy, request)
            def listFieldLevelEncryptionProfiles(
                request: ListFieldLevelEncryptionProfilesRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesResponse.ReadOnly
            ] = proxy(ListFieldLevelEncryptionProfiles, request)
            def getOriginRequestPolicy(
                request: GetOriginRequestPolicyRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly
            ] = proxy(GetOriginRequestPolicy, request)
            def deleteFunction(
                request: DeleteFunctionRequest
            ): IO[AwsError, Unit] = proxy(DeleteFunction, request)
            def createFieldLevelEncryptionConfig(
                request: CreateFieldLevelEncryptionConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateFieldLevelEncryptionConfigResponse.ReadOnly
            ] = proxy(CreateFieldLevelEncryptionConfig, request)
            def getFieldLevelEncryptionProfileConfig(
                request: GetFieldLevelEncryptionProfileConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse.ReadOnly
            ] = proxy(GetFieldLevelEncryptionProfileConfig, request)
            def getCloudFrontOriginAccessIdentity(
                request: GetCloudFrontOriginAccessIdentityRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse.ReadOnly
            ] = proxy(GetCloudFrontOriginAccessIdentity, request)
            def createKeyGroup(
                request: CreateKeyGroupRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateKeyGroup, request)
            def getMonitoringSubscription(
                request: GetMonitoringSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.ReadOnly
            ] = proxy(GetMonitoringSubscription, request)
            def listDistributions(request: ListDistributionsRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.ListDistributionsResponse.ReadOnly
            ] = proxy(ListDistributions, request)
            def deleteStreamingDistribution(
                request: DeleteStreamingDistributionRequest
            ): IO[AwsError, Unit] = proxy(DeleteStreamingDistribution, request)
            def listStreamingDistributions(
                request: ListStreamingDistributionsRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListStreamingDistributionsResponse.ReadOnly
            ] = proxy(ListStreamingDistributions, request)
            def listRealtimeLogConfigs(
                request: ListRealtimeLogConfigsRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListRealtimeLogConfigsResponse.ReadOnly
            ] = proxy(ListRealtimeLogConfigs, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def deleteOriginRequestPolicy(
                request: DeleteOriginRequestPolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteOriginRequestPolicy, request)
            def deleteRealtimeLogConfig(
                request: DeleteRealtimeLogConfigRequest
            ): IO[AwsError, Unit] = proxy(DeleteRealtimeLogConfig, request)
            def deleteResponseHeadersPolicy(
                request: DeleteResponseHeadersPolicyRequest
            ): IO[AwsError, Unit] = proxy(DeleteResponseHeadersPolicy, request)
            def updateFunction(request: UpdateFunctionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateFunctionResponse.ReadOnly
            ] = proxy(UpdateFunction, request)
            def createInvalidation(request: CreateInvalidationRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateInvalidationResponse.ReadOnly
            ] = proxy(CreateInvalidation, request)
            def listDistributionsByRealtimeLogConfig(
                request: ListDistributionsByRealtimeLogConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse.ReadOnly
            ] = proxy(ListDistributionsByRealtimeLogConfig, request)
            def getResponseHeadersPolicyConfig(
                request: GetResponseHeadersPolicyConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetResponseHeadersPolicyConfigResponse.ReadOnly
            ] = proxy(GetResponseHeadersPolicyConfig, request)
            def getDistributionConfig(
                request: GetDistributionConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetDistributionConfigResponse.ReadOnly
            ] = proxy(GetDistributionConfig, request)
            def createPublicKey(request: CreatePublicKeyRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.CreatePublicKeyResponse.ReadOnly
            ] = proxy(CreatePublicKey, request)
            def updateKeyGroup(request: UpdateKeyGroupRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateKeyGroupResponse.ReadOnly
            ] = proxy(UpdateKeyGroup, request)
            def updateOriginRequestPolicy(
                request: UpdateOriginRequestPolicyRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly
            ] = proxy(UpdateOriginRequestPolicy, request)
            def createCloudFrontOriginAccessIdentity(
                request: CreateCloudFrontOriginAccessIdentityRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse.ReadOnly
            ] = proxy(CreateCloudFrontOriginAccessIdentity, request)
            def associateAlias(
                request: AssociateAliasRequest
            ): IO[AwsError, Unit] = proxy(AssociateAlias, request)
            def updatePublicKey(request: UpdatePublicKeyRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdatePublicKeyResponse.ReadOnly
            ] = proxy(UpdatePublicKey, request)
            def listDistributionsByCachePolicyId(
                request: ListDistributionsByCachePolicyIdRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdResponse.ReadOnly
            ] = proxy(ListDistributionsByCachePolicyId, request)
            def getCloudFrontOriginAccessIdentityConfig(
                request: GetCloudFrontOriginAccessIdentityConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly
            ] = proxy(GetCloudFrontOriginAccessIdentityConfig, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getCachePolicyConfig(request: GetCachePolicyConfigRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetCachePolicyConfigResponse.ReadOnly
            ] = proxy(GetCachePolicyConfig, request)
            def listKeyGroups(request: ListKeyGroupsRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly
            ] = proxy(ListKeyGroups, request)
            def getFieldLevelEncryption(
                request: GetFieldLevelEncryptionRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetFieldLevelEncryptionResponse.ReadOnly
            ] = proxy(GetFieldLevelEncryption, request)
            def publishFunction(request: PublishFunctionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.PublishFunctionResponse.ReadOnly
            ] = proxy(PublishFunction, request)
            def createOriginRequestPolicy(
                request: CreateOriginRequestPolicyRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateOriginRequestPolicyResponse.ReadOnly
            ] = proxy(CreateOriginRequestPolicy, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def deleteMonitoringSubscription(
                request: DeleteMonitoringSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.DeleteMonitoringSubscriptionResponse.ReadOnly
            ] = proxy(DeleteMonitoringSubscription, request)
            def getStreamingDistributionConfig(
                request: GetStreamingDistributionConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetStreamingDistributionConfigResponse.ReadOnly
            ] = proxy(GetStreamingDistributionConfig, request)
            def updateFieldLevelEncryptionProfile(
                request: UpdateFieldLevelEncryptionProfileRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.ReadOnly
            ] = proxy(UpdateFieldLevelEncryptionProfile, request)
            def createFieldLevelEncryptionProfile(
                request: CreateFieldLevelEncryptionProfileRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateFieldLevelEncryptionProfileResponse.ReadOnly
            ] = proxy(CreateFieldLevelEncryptionProfile, request)
            def listFunctions(request: ListFunctionsRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.ListFunctionsResponse.ReadOnly
            ] = proxy(ListFunctions, request)
            def deleteFieldLevelEncryptionProfile(
                request: DeleteFieldLevelEncryptionProfileRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteFieldLevelEncryptionProfile, request)
            def getResponseHeadersPolicy(
                request: GetResponseHeadersPolicyRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly
            ] = proxy(GetResponseHeadersPolicy, request)
            def listInvalidations(request: ListInvalidationsRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.ListInvalidationsResponse.ReadOnly
            ] = proxy(ListInvalidations, request)
            def createResponseHeadersPolicy(
                request: CreateResponseHeadersPolicyRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.ReadOnly
            ] = proxy(CreateResponseHeadersPolicy, request)
            def getKeyGroupConfig(request: GetKeyGroupConfigRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetKeyGroupConfigResponse.ReadOnly
            ] = proxy(GetKeyGroupConfig, request)
            def updateCloudFrontOriginAccessIdentity(
                request: UpdateCloudFrontOriginAccessIdentityRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.ReadOnly
            ] = proxy(UpdateCloudFrontOriginAccessIdentity, request)
            def listDistributionsByResponseHeadersPolicyId(
                request: ListDistributionsByResponseHeadersPolicyIdRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse.ReadOnly
            ] = proxy(ListDistributionsByResponseHeadersPolicyId, request)
            def updateCachePolicy(request: UpdateCachePolicyRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateCachePolicyResponse.ReadOnly
            ] = proxy(UpdateCachePolicy, request)
            def createFunction(request: CreateFunctionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateFunctionResponse.ReadOnly
            ] = proxy(CreateFunction, request)
            def getOriginAccessControlConfig(
                request: GetOriginAccessControlConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetOriginAccessControlConfigResponse.ReadOnly
            ] = proxy(GetOriginAccessControlConfig, request)
            def getCachePolicy(request: GetCachePolicyRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetCachePolicyResponse.ReadOnly
            ] = proxy(GetCachePolicy, request)
            def getDistribution(request: GetDistributionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetDistributionResponse.ReadOnly
            ] = proxy(GetDistribution, request)
            def getOriginRequestPolicyConfig(
                request: GetOriginRequestPolicyConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.ReadOnly
            ] = proxy(GetOriginRequestPolicyConfig, request)
            def listCloudFrontOriginAccessIdentities(
                request: ListCloudFrontOriginAccessIdentitiesRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse.ReadOnly
            ] = proxy(ListCloudFrontOriginAccessIdentities, request)
            def updateDistribution(request: UpdateDistributionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateDistributionResponse.ReadOnly
            ] = proxy(UpdateDistribution, request)
            def getFunction(request: GetFunctionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.GetFunctionResponse.ReadOnly
            ] = proxy(GetFunction, request)
            def deleteDistribution(
                request: DeleteDistributionRequest
            ): IO[AwsError, Unit] = proxy(DeleteDistribution, request)
            def updateFieldLevelEncryptionConfig(
                request: UpdateFieldLevelEncryptionConfigRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse.ReadOnly
            ] = proxy(UpdateFieldLevelEncryptionConfig, request)
            def listDistributionsByKeyGroup(
                request: ListDistributionsByKeyGroupRequest
            ): IO[
              AwsError,
              zio.aws.cloudfront.model.ListDistributionsByKeyGroupResponse.ReadOnly
            ] = proxy(ListDistributionsByKeyGroup, request)
            def createDistribution(request: CreateDistributionRequest): IO[
              AwsError,
              zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly
            ] = proxy(CreateDistribution, request)
          }
        }
      }
    }
  }
}
