package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCloudFrontOriginAccessIdentitiesRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest = {
    import ListCloudFrontOriginAccessIdentitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest.ReadOnly =
    zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest
      .wrap(buildAwsValue())
}
object ListCloudFrontOriginAccessIdentitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest =
      zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest
  ) extends zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest
  ): zio.aws.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest.ReadOnly =
    new Wrapper(impl)
}
