package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContentTypeProfileConfig(
    forwardWhenContentTypeIsUnknown: Boolean,
    contentTypeProfiles: Optional[
      zio.aws.cloudfront.model.ContentTypeProfiles
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ContentTypeProfileConfig = {
    import ContentTypeProfileConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ContentTypeProfileConfig
      .builder()
      .forwardWhenContentTypeIsUnknown(
        forwardWhenContentTypeIsUnknown: java.lang.Boolean
      )
      .optionallyWith(contentTypeProfiles.map(value => value.buildAwsValue()))(
        _.contentTypeProfiles
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly =
    zio.aws.cloudfront.model.ContentTypeProfileConfig.wrap(buildAwsValue())
}
object ContentTypeProfileConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ContentTypeProfileConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ContentTypeProfileConfig =
      zio.aws.cloudfront.model.ContentTypeProfileConfig(
        forwardWhenContentTypeIsUnknown,
        contentTypeProfiles.map(value => value.asEditable)
      )
    def forwardWhenContentTypeIsUnknown: Boolean
    def contentTypeProfiles
        : Optional[zio.aws.cloudfront.model.ContentTypeProfiles.ReadOnly]
    def getForwardWhenContentTypeIsUnknown: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(forwardWhenContentTypeIsUnknown)
    def getContentTypeProfiles: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContentTypeProfiles.ReadOnly
    ] = AwsError.unwrapOptionField("contentTypeProfiles", contentTypeProfiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ContentTypeProfileConfig
  ) extends zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly {
    override val forwardWhenContentTypeIsUnknown: Boolean =
      impl.forwardWhenContentTypeIsUnknown(): Boolean
    override val contentTypeProfiles
        : Optional[zio.aws.cloudfront.model.ContentTypeProfiles.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentTypeProfiles())
        .map(value => zio.aws.cloudfront.model.ContentTypeProfiles.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ContentTypeProfileConfig
  ): zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly = new Wrapper(
    impl
  )
}
