package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Restrictions(
    geoRestriction: zio.aws.cloudfront.model.GeoRestriction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Restrictions = {
    import Restrictions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Restrictions
      .builder()
      .geoRestriction(geoRestriction.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Restrictions.ReadOnly =
    zio.aws.cloudfront.model.Restrictions.wrap(buildAwsValue())
}
object Restrictions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.Restrictions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Restrictions =
      zio.aws.cloudfront.model.Restrictions(geoRestriction.asEditable)
    def geoRestriction: zio.aws.cloudfront.model.GeoRestriction.ReadOnly
    def getGeoRestriction
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.GeoRestriction.ReadOnly] =
      ZIO.succeed(geoRestriction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Restrictions
  ) extends zio.aws.cloudfront.model.Restrictions.ReadOnly {
    override val geoRestriction
        : zio.aws.cloudfront.model.GeoRestriction.ReadOnly =
      zio.aws.cloudfront.model.GeoRestriction.wrap(impl.geoRestriction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Restrictions
  ): zio.aws.cloudfront.model.Restrictions.ReadOnly = new Wrapper(impl)
}
