package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetOriginRequestPolicyConfigResponse(
    originRequestPolicyConfig: Optional[
      zio.aws.cloudfront.model.OriginRequestPolicyConfig
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse = {
    import GetOriginRequestPolicyConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse
      .builder()
      .optionallyWith(
        originRequestPolicyConfig.map(value => value.buildAwsValue())
      )(_.originRequestPolicyConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse
      .wrap(buildAwsValue())
}
object GetOriginRequestPolicyConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse =
      zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse(
        originRequestPolicyConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def originRequestPolicyConfig
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly]
    def eTag: Optional[String]
    def getOriginRequestPolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "originRequestPolicyConfig",
      originRequestPolicyConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse
  ) extends zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.ReadOnly {
    override val originRequestPolicyConfig: Optional[
      zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originRequestPolicyConfig())
      .map(value =>
        zio.aws.cloudfront.model.OriginRequestPolicyConfig.wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse
  ): zio.aws.cloudfront.model.GetOriginRequestPolicyConfigResponse.ReadOnly =
    new Wrapper(impl)
}
