package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStreamingDistributionResponse(
    streamingDistribution: Optional[
      zio.aws.cloudfront.model.StreamingDistribution
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse = {
    import UpdateStreamingDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse
      .builder()
      .optionallyWith(
        streamingDistribution.map(value => value.buildAwsValue())
      )(_.streamingDistribution)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateStreamingDistributionResponse
      .wrap(buildAwsValue())
}
object UpdateStreamingDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateStreamingDistributionResponse =
      zio.aws.cloudfront.model.UpdateStreamingDistributionResponse(
        streamingDistribution.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def streamingDistribution
        : Optional[zio.aws.cloudfront.model.StreamingDistribution.ReadOnly]
    def eTag: Optional[String]
    def getStreamingDistribution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.StreamingDistribution.ReadOnly
    ] =
      AwsError.unwrapOptionField("streamingDistribution", streamingDistribution)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse
  ) extends zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.ReadOnly {
    override val streamingDistribution
        : Optional[zio.aws.cloudfront.model.StreamingDistribution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingDistribution())
        .map(value =>
          zio.aws.cloudfront.model.StreamingDistribution.wrap(value)
        )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse
  ): zio.aws.cloudfront.model.UpdateStreamingDistributionResponse.ReadOnly =
    new Wrapper(impl)
}
