package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OriginRequestPolicyQueryStringsConfig(
    queryStringBehavior: zio.aws.cloudfront.model.OriginRequestPolicyQueryStringBehavior,
    queryStrings: Optional[zio.aws.cloudfront.model.QueryStringNames] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig = {
    import OriginRequestPolicyQueryStringsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig
      .builder()
      .queryStringBehavior(queryStringBehavior.unwrap)
      .optionallyWith(queryStrings.map(value => value.buildAwsValue()))(
        _.queryStrings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig.ReadOnly =
    zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig
      .wrap(buildAwsValue())
}
object OriginRequestPolicyQueryStringsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig =
      zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig(
        queryStringBehavior,
        queryStrings.map(value => value.asEditable)
      )
    def queryStringBehavior
        : zio.aws.cloudfront.model.OriginRequestPolicyQueryStringBehavior
    def queryStrings
        : Optional[zio.aws.cloudfront.model.QueryStringNames.ReadOnly]
    def getQueryStringBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyQueryStringBehavior
    ] = ZIO.succeed(queryStringBehavior)
    def getQueryStrings: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.QueryStringNames.ReadOnly
    ] = AwsError.unwrapOptionField("queryStrings", queryStrings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig
  ) extends zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig.ReadOnly {
    override val queryStringBehavior
        : zio.aws.cloudfront.model.OriginRequestPolicyQueryStringBehavior =
      zio.aws.cloudfront.model.OriginRequestPolicyQueryStringBehavior
        .wrap(impl.queryStringBehavior())
    override val queryStrings
        : Optional[zio.aws.cloudfront.model.QueryStringNames.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryStrings())
        .map(value => zio.aws.cloudfront.model.QueryStringNames.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyQueryStringsConfig
  ): zio.aws.cloudfront.model.OriginRequestPolicyQueryStringsConfig.ReadOnly =
    new Wrapper(impl)
}
