package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMonitoringSubscriptionRequest(distributionId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest = {
    import DeleteMonitoringSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest
      .builder()
      .distributionId(distributionId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteMonitoringSubscriptionRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteMonitoringSubscriptionRequest
      .wrap(buildAwsValue())
}
object DeleteMonitoringSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.DeleteMonitoringSubscriptionRequest =
      zio.aws.cloudfront.model
        .DeleteMonitoringSubscriptionRequest(distributionId)
    def distributionId: String
    def getDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest
  ) extends zio.aws.cloudfront.model.DeleteMonitoringSubscriptionRequest.ReadOnly {
    override val distributionId: String = impl.distributionId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest
  ): zio.aws.cloudfront.model.DeleteMonitoringSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
