package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateOriginRequestPolicyRequest(
    originRequestPolicyConfig: zio.aws.cloudfront.model.OriginRequestPolicyConfig,
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest = {
    import UpdateOriginRequestPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest
      .builder()
      .originRequestPolicyConfig(originRequestPolicyConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateOriginRequestPolicyRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateOriginRequestPolicyRequest
      .wrap(buildAwsValue())
}
object UpdateOriginRequestPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateOriginRequestPolicyRequest =
      zio.aws.cloudfront.model.UpdateOriginRequestPolicyRequest(
        originRequestPolicyConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def originRequestPolicyConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly
    def id: String
    def ifMatch: Optional[String]
    def getOriginRequestPolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly
    ] = ZIO.succeed(originRequestPolicyConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest
  ) extends zio.aws.cloudfront.model.UpdateOriginRequestPolicyRequest.ReadOnly {
    override val originRequestPolicyConfig
        : zio.aws.cloudfront.model.OriginRequestPolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.OriginRequestPolicyConfig
        .wrap(impl.originRequestPolicyConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest
  ): zio.aws.cloudfront.model.UpdateOriginRequestPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
