package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCloudFrontOriginAccessIdentityConfigResponse(
    cloudFrontOriginAccessIdentityConfig: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse = {
    import GetCloudFrontOriginAccessIdentityConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
      .builder()
      .optionallyWith(
        cloudFrontOriginAccessIdentityConfig.map(value => value.buildAwsValue())
      )(_.cloudFrontOriginAccessIdentityConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
      .wrap(buildAwsValue())
}
object GetCloudFrontOriginAccessIdentityConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse =
      zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse(
        cloudFrontOriginAccessIdentityConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def cloudFrontOriginAccessIdentityConfig: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ]
    def eTag: Optional[String]
    def getCloudFrontOriginAccessIdentityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudFrontOriginAccessIdentityConfig",
      cloudFrontOriginAccessIdentityConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
  ) extends zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly {
    override val cloudFrontOriginAccessIdentityConfig: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudFrontOriginAccessIdentityConfig())
      .map(value =>
        zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
          .wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse
  ): zio.aws.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse.ReadOnly =
    new Wrapper(impl)
}
