package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DefaultCacheBehavior(
    targetOriginId: String,
    trustedSigners: Optional[zio.aws.cloudfront.model.TrustedSigners] =
      Optional.Absent,
    trustedKeyGroups: Optional[zio.aws.cloudfront.model.TrustedKeyGroups] =
      Optional.Absent,
    viewerProtocolPolicy: zio.aws.cloudfront.model.ViewerProtocolPolicy,
    allowedMethods: Optional[zio.aws.cloudfront.model.AllowedMethods] =
      Optional.Absent,
    smoothStreaming: Optional[Boolean] = Optional.Absent,
    compress: Optional[Boolean] = Optional.Absent,
    lambdaFunctionAssociations: Optional[
      zio.aws.cloudfront.model.LambdaFunctionAssociations
    ] = Optional.Absent,
    functionAssociations: Optional[
      zio.aws.cloudfront.model.FunctionAssociations
    ] = Optional.Absent,
    fieldLevelEncryptionId: Optional[String] = Optional.Absent,
    realtimeLogConfigArn: Optional[String] = Optional.Absent,
    cachePolicyId: Optional[String] = Optional.Absent,
    originRequestPolicyId: Optional[String] = Optional.Absent,
    responseHeadersPolicyId: Optional[String] = Optional.Absent,
    forwardedValues: Optional[zio.aws.cloudfront.model.ForwardedValues] =
      Optional.Absent,
    minTTL: Optional[Long] = Optional.Absent,
    defaultTTL: Optional[Long] = Optional.Absent,
    maxTTL: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior = {
    import DefaultCacheBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior
      .builder()
      .targetOriginId(targetOriginId: java.lang.String)
      .optionallyWith(trustedSigners.map(value => value.buildAwsValue()))(
        _.trustedSigners
      )
      .optionallyWith(trustedKeyGroups.map(value => value.buildAwsValue()))(
        _.trustedKeyGroups
      )
      .viewerProtocolPolicy(viewerProtocolPolicy.unwrap)
      .optionallyWith(allowedMethods.map(value => value.buildAwsValue()))(
        _.allowedMethods
      )
      .optionallyWith(smoothStreaming.map(value => value: java.lang.Boolean))(
        _.smoothStreaming
      )
      .optionallyWith(compress.map(value => value: java.lang.Boolean))(
        _.compress
      )
      .optionallyWith(
        lambdaFunctionAssociations.map(value => value.buildAwsValue())
      )(_.lambdaFunctionAssociations)
      .optionallyWith(functionAssociations.map(value => value.buildAwsValue()))(
        _.functionAssociations
      )
      .optionallyWith(
        fieldLevelEncryptionId.map(value => value: java.lang.String)
      )(_.fieldLevelEncryptionId)
      .optionallyWith(
        realtimeLogConfigArn.map(value => value: java.lang.String)
      )(_.realtimeLogConfigArn)
      .optionallyWith(cachePolicyId.map(value => value: java.lang.String))(
        _.cachePolicyId
      )
      .optionallyWith(
        originRequestPolicyId.map(value => value: java.lang.String)
      )(_.originRequestPolicyId)
      .optionallyWith(
        responseHeadersPolicyId.map(value => value: java.lang.String)
      )(_.responseHeadersPolicyId)
      .optionallyWith(forwardedValues.map(value => value.buildAwsValue()))(
        _.forwardedValues
      )
      .optionallyWith(minTTL.map(value => value: java.lang.Long))(_.minTTL)
      .optionallyWith(defaultTTL.map(value => value: java.lang.Long))(
        _.defaultTTL
      )
      .optionallyWith(maxTTL.map(value => value: java.lang.Long))(_.maxTTL)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly =
    zio.aws.cloudfront.model.DefaultCacheBehavior.wrap(buildAwsValue())
}
object DefaultCacheBehavior {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DefaultCacheBehavior =
      zio.aws.cloudfront.model.DefaultCacheBehavior(
        targetOriginId,
        trustedSigners.map(value => value.asEditable),
        trustedKeyGroups.map(value => value.asEditable),
        viewerProtocolPolicy,
        allowedMethods.map(value => value.asEditable),
        smoothStreaming.map(value => value),
        compress.map(value => value),
        lambdaFunctionAssociations.map(value => value.asEditable),
        functionAssociations.map(value => value.asEditable),
        fieldLevelEncryptionId.map(value => value),
        realtimeLogConfigArn.map(value => value),
        cachePolicyId.map(value => value),
        originRequestPolicyId.map(value => value),
        responseHeadersPolicyId.map(value => value),
        forwardedValues.map(value => value.asEditable),
        minTTL.map(value => value),
        defaultTTL.map(value => value),
        maxTTL.map(value => value)
      )
    def targetOriginId: String
    def trustedSigners
        : Optional[zio.aws.cloudfront.model.TrustedSigners.ReadOnly]
    def trustedKeyGroups
        : Optional[zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly]
    def viewerProtocolPolicy: zio.aws.cloudfront.model.ViewerProtocolPolicy
    def allowedMethods
        : Optional[zio.aws.cloudfront.model.AllowedMethods.ReadOnly]
    def smoothStreaming: Optional[Boolean]
    def compress: Optional[Boolean]
    def lambdaFunctionAssociations
        : Optional[zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly]
    def functionAssociations
        : Optional[zio.aws.cloudfront.model.FunctionAssociations.ReadOnly]
    def fieldLevelEncryptionId: Optional[String]
    def realtimeLogConfigArn: Optional[String]
    def cachePolicyId: Optional[String]
    def originRequestPolicyId: Optional[String]
    def responseHeadersPolicyId: Optional[String]
    def forwardedValues
        : Optional[zio.aws.cloudfront.model.ForwardedValues.ReadOnly]
    def minTTL: Optional[Long]
    def defaultTTL: Optional[Long]
    def maxTTL: Optional[Long]
    def getTargetOriginId: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetOriginId)
    def getTrustedSigners
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.TrustedSigners.ReadOnly] =
      AwsError.unwrapOptionField("trustedSigners", trustedSigners)
    def getTrustedKeyGroups: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly
    ] = AwsError.unwrapOptionField("trustedKeyGroups", trustedKeyGroups)
    def getViewerProtocolPolicy
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.ViewerProtocolPolicy] =
      ZIO.succeed(viewerProtocolPolicy)
    def getAllowedMethods
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.AllowedMethods.ReadOnly] =
      AwsError.unwrapOptionField("allowedMethods", allowedMethods)
    def getSmoothStreaming: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("smoothStreaming", smoothStreaming)
    def getCompress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("compress", compress)
    def getLambdaFunctionAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaFunctionAssociations",
      lambdaFunctionAssociations
    )
    def getFunctionAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FunctionAssociations.ReadOnly
    ] = AwsError.unwrapOptionField("functionAssociations", functionAssociations)
    def getFieldLevelEncryptionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("fieldLevelEncryptionId", fieldLevelEncryptionId)
    def getRealtimeLogConfigArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("realtimeLogConfigArn", realtimeLogConfigArn)
    def getCachePolicyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cachePolicyId", cachePolicyId)
    def getOriginRequestPolicyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originRequestPolicyId", originRequestPolicyId)
    def getResponseHeadersPolicyId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("responseHeadersPolicyId", responseHeadersPolicyId)
    def getForwardedValues: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ForwardedValues.ReadOnly
    ] = AwsError.unwrapOptionField("forwardedValues", forwardedValues)
    def getMinTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minTTL", minTTL)
    def getDefaultTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("defaultTTL", defaultTTL)
    def getMaxTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxTTL", maxTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior
  ) extends zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly {
    override val targetOriginId: String = impl.targetOriginId(): String
    override val trustedSigners
        : Optional[zio.aws.cloudfront.model.TrustedSigners.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustedSigners())
        .map(value => zio.aws.cloudfront.model.TrustedSigners.wrap(value))
    override val trustedKeyGroups
        : Optional[zio.aws.cloudfront.model.TrustedKeyGroups.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustedKeyGroups())
        .map(value => zio.aws.cloudfront.model.TrustedKeyGroups.wrap(value))
    override val viewerProtocolPolicy
        : zio.aws.cloudfront.model.ViewerProtocolPolicy =
      zio.aws.cloudfront.model.ViewerProtocolPolicy
        .wrap(impl.viewerProtocolPolicy())
    override val allowedMethods
        : Optional[zio.aws.cloudfront.model.AllowedMethods.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedMethods())
        .map(value => zio.aws.cloudfront.model.AllowedMethods.wrap(value))
    override val smoothStreaming: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.smoothStreaming())
      .map(value => value: Boolean)
    override val compress: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.compress())
      .map(value => value: Boolean)
    override val lambdaFunctionAssociations: Optional[
      zio.aws.cloudfront.model.LambdaFunctionAssociations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionAssociations())
      .map(value =>
        zio.aws.cloudfront.model.LambdaFunctionAssociations.wrap(value)
      )
    override val functionAssociations
        : Optional[zio.aws.cloudfront.model.FunctionAssociations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionAssociations())
        .map(value => zio.aws.cloudfront.model.FunctionAssociations.wrap(value))
    override val fieldLevelEncryptionId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fieldLevelEncryptionId())
        .map(value => value: String)
    override val realtimeLogConfigArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.realtimeLogConfigArn())
      .map(value => value: String)
    override val cachePolicyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cachePolicyId())
      .map(value => value: String)
    override val originRequestPolicyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.originRequestPolicyId())
      .map(value => value: String)
    override val responseHeadersPolicyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseHeadersPolicyId())
        .map(value => value: String)
    override val forwardedValues
        : Optional[zio.aws.cloudfront.model.ForwardedValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forwardedValues())
        .map(value => zio.aws.cloudfront.model.ForwardedValues.wrap(value))
    override val minTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.minTTL())
      .map(value => value: Long)
    override val defaultTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultTTL())
      .map(value => value: Long)
    override val maxTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.maxTTL())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior
  ): zio.aws.cloudfront.model.DefaultCacheBehavior.ReadOnly = new Wrapper(impl)
}
