package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetOriginRequestPolicyResponse(
    originRequestPolicy: Optional[
      zio.aws.cloudfront.model.OriginRequestPolicy
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse = {
    import GetOriginRequestPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse
      .builder()
      .optionallyWith(originRequestPolicy.map(value => value.buildAwsValue()))(
        _.originRequestPolicy
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.GetOriginRequestPolicyResponse
      .wrap(buildAwsValue())
}
object GetOriginRequestPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetOriginRequestPolicyResponse =
      zio.aws.cloudfront.model.GetOriginRequestPolicyResponse(
        originRequestPolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def originRequestPolicy
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly]
    def eTag: Optional[String]
    def getOriginRequestPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("originRequestPolicy", originRequestPolicy)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse
  ) extends zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly {
    override val originRequestPolicy
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originRequestPolicy())
        .map(value => zio.aws.cloudfront.model.OriginRequestPolicy.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse
  ): zio.aws.cloudfront.model.GetOriginRequestPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
