package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateDistributionRequest(
    distributionConfig: zio.aws.cloudfront.model.DistributionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest = {
    import CreateDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest
      .builder()
      .distributionConfig(distributionConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateDistributionRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateDistributionRequest.wrap(buildAwsValue())
}
object CreateDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateDistributionRequest =
      zio.aws.cloudfront.model
        .CreateDistributionRequest(distributionConfig.asEditable)
    def distributionConfig: zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    def getDistributionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    ] = ZIO.succeed(distributionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest
  ) extends zio.aws.cloudfront.model.CreateDistributionRequest.ReadOnly {
    override val distributionConfig
        : zio.aws.cloudfront.model.DistributionConfig.ReadOnly =
      zio.aws.cloudfront.model.DistributionConfig
        .wrap(impl.distributionConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest
  ): zio.aws.cloudfront.model.CreateDistributionRequest.ReadOnly = new Wrapper(
    impl
  )
}
