package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPublicKeyConfigResponse(
    publicKeyConfig: Optional[zio.aws.cloudfront.model.PublicKeyConfig] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse = {
    import GetPublicKeyConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse
      .builder()
      .optionallyWith(publicKeyConfig.map(value => value.buildAwsValue()))(
        _.publicKeyConfig
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetPublicKeyConfigResponse.wrap(buildAwsValue())
}
object GetPublicKeyConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetPublicKeyConfigResponse =
      zio.aws.cloudfront.model.GetPublicKeyConfigResponse(
        publicKeyConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def publicKeyConfig
        : Optional[zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly]
    def eTag: Optional[String]
    def getPublicKeyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("publicKeyConfig", publicKeyConfig)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse
  ) extends zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly {
    override val publicKeyConfig
        : Optional[zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicKeyConfig())
        .map(value => zio.aws.cloudfront.model.PublicKeyConfig.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse
  ): zio.aws.cloudfront.model.GetPublicKeyConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
