package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StreamingDistributionConfigWithTags(
    streamingDistributionConfig: zio.aws.cloudfront.model.StreamingDistributionConfig,
    tags: zio.aws.cloudfront.model.Tags
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfigWithTags = {
    import StreamingDistributionConfigWithTags.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfigWithTags
      .builder()
      .streamingDistributionConfig(streamingDistributionConfig.buildAwsValue())
      .tags(tags.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.StreamingDistributionConfigWithTags.ReadOnly =
    zio.aws.cloudfront.model.StreamingDistributionConfigWithTags
      .wrap(buildAwsValue())
}
object StreamingDistributionConfigWithTags {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfigWithTags
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.StreamingDistributionConfigWithTags =
      zio.aws.cloudfront.model.StreamingDistributionConfigWithTags(
        streamingDistributionConfig.asEditable,
        tags.asEditable
      )
    def streamingDistributionConfig
        : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    def tags: zio.aws.cloudfront.model.Tags.ReadOnly
    def getStreamingDistributionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    ] = ZIO.succeed(streamingDistributionConfig)
    def getTags: ZIO[Any, Nothing, zio.aws.cloudfront.model.Tags.ReadOnly] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfigWithTags
  ) extends zio.aws.cloudfront.model.StreamingDistributionConfigWithTags.ReadOnly {
    override val streamingDistributionConfig
        : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly =
      zio.aws.cloudfront.model.StreamingDistributionConfig
        .wrap(impl.streamingDistributionConfig())
    override val tags: zio.aws.cloudfront.model.Tags.ReadOnly =
      zio.aws.cloudfront.model.Tags.wrap(impl.tags())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfigWithTags
  ): zio.aws.cloudfront.model.StreamingDistributionConfigWithTags.ReadOnly =
    new Wrapper(impl)
}
