package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.SamplingRate
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyServerTimingHeadersConfig(
    enabled: Boolean,
    samplingRate: Optional[SamplingRate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig = {
    import ResponseHeadersPolicyServerTimingHeadersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        samplingRate.map(value => SamplingRate.unwrap(value): java.lang.Double)
      )(_.samplingRate)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyServerTimingHeadersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig =
      zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig(
        enabled,
        samplingRate.map(value => value)
      )
    def enabled: Boolean
    def samplingRate: Optional[SamplingRate]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getSamplingRate: ZIO[Any, AwsError, SamplingRate] =
      AwsError.unwrapOptionField("samplingRate", samplingRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val samplingRate: Optional[SamplingRate] = zio.aws.core.internal
      .optionalFromNullable(impl.samplingRate())
      .map(value => zio.aws.cloudfront.model.primitives.SamplingRate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyServerTimingHeadersConfig.ReadOnly =
    new Wrapper(impl)
}
