package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StreamingDistributionSummary(
    id: String,
    arn: String,
    status: String,
    lastModifiedTime: Timestamp,
    domainName: String,
    s3Origin: zio.aws.cloudfront.model.S3Origin,
    aliases: zio.aws.cloudfront.model.Aliases,
    trustedSigners: zio.aws.cloudfront.model.TrustedSigners,
    comment: String,
    priceClass: zio.aws.cloudfront.model.PriceClass,
    enabled: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary = {
    import StreamingDistributionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary
      .builder()
      .id(id: java.lang.String)
      .arn(arn: java.lang.String)
      .status(status: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .domainName(domainName: java.lang.String)
      .s3Origin(s3Origin.buildAwsValue())
      .aliases(aliases.buildAwsValue())
      .trustedSigners(trustedSigners.buildAwsValue())
      .comment(comment: java.lang.String)
      .priceClass(priceClass.unwrap)
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.StreamingDistributionSummary.ReadOnly =
    zio.aws.cloudfront.model.StreamingDistributionSummary.wrap(buildAwsValue())
}
object StreamingDistributionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.StreamingDistributionSummary =
      zio.aws.cloudfront.model.StreamingDistributionSummary(
        id,
        arn,
        status,
        lastModifiedTime,
        domainName,
        s3Origin.asEditable,
        aliases.asEditable,
        trustedSigners.asEditable,
        comment,
        priceClass,
        enabled
      )
    def id: String
    def arn: String
    def status: String
    def lastModifiedTime: Timestamp
    def domainName: String
    def s3Origin: zio.aws.cloudfront.model.S3Origin.ReadOnly
    def aliases: zio.aws.cloudfront.model.Aliases.ReadOnly
    def trustedSigners: zio.aws.cloudfront.model.TrustedSigners.ReadOnly
    def comment: String
    def priceClass: zio.aws.cloudfront.model.PriceClass
    def enabled: Boolean
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getS3Origin
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.S3Origin.ReadOnly] =
      ZIO.succeed(s3Origin)
    def getAliases
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.Aliases.ReadOnly] =
      ZIO.succeed(aliases)
    def getTrustedSigners
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.TrustedSigners.ReadOnly] =
      ZIO.succeed(trustedSigners)
    def getComment: ZIO[Any, Nothing, String] = ZIO.succeed(comment)
    def getPriceClass: ZIO[Any, Nothing, zio.aws.cloudfront.model.PriceClass] =
      ZIO.succeed(priceClass)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary
  ) extends zio.aws.cloudfront.model.StreamingDistributionSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val arn: String = impl.arn(): String
    override val status: String = impl.status(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val domainName: String = impl.domainName(): String
    override val s3Origin: zio.aws.cloudfront.model.S3Origin.ReadOnly =
      zio.aws.cloudfront.model.S3Origin.wrap(impl.s3Origin())
    override val aliases: zio.aws.cloudfront.model.Aliases.ReadOnly =
      zio.aws.cloudfront.model.Aliases.wrap(impl.aliases())
    override val trustedSigners
        : zio.aws.cloudfront.model.TrustedSigners.ReadOnly =
      zio.aws.cloudfront.model.TrustedSigners.wrap(impl.trustedSigners())
    override val comment: String = impl.comment(): String
    override val priceClass: zio.aws.cloudfront.model.PriceClass =
      zio.aws.cloudfront.model.PriceClass.wrap(impl.priceClass())
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary
  ): zio.aws.cloudfront.model.StreamingDistributionSummary.ReadOnly =
    new Wrapper(impl)
}
