package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.ResourceARN
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resource: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest
      .builder()
      .resource(ResourceARN.unwrap(resource): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.cloudfront.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListTagsForResourceRequest =
      zio.aws.cloudfront.model.ListTagsForResourceRequest(resource)
    def resource: ResourceARN
    def getResource: ZIO[Any, Nothing, ResourceARN] = ZIO.succeed(resource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest
  ) extends zio.aws.cloudfront.model.ListTagsForResourceRequest.ReadOnly {
    override val resource: ResourceARN =
      zio.aws.cloudfront.model.primitives.ResourceARN(impl.resource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest
  ): zio.aws.cloudfront.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
