package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.FunctionARN
import scala.jdk.CollectionConverters._
final case class FunctionAssociation(
    functionARN: FunctionARN,
    eventType: zio.aws.cloudfront.model.EventType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FunctionAssociation = {
    import FunctionAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FunctionAssociation
      .builder()
      .functionARN(FunctionARN.unwrap(functionARN): java.lang.String)
      .eventType(eventType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FunctionAssociation.ReadOnly =
    zio.aws.cloudfront.model.FunctionAssociation.wrap(buildAwsValue())
}
object FunctionAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FunctionAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FunctionAssociation =
      zio.aws.cloudfront.model.FunctionAssociation(functionARN, eventType)
    def functionARN: FunctionARN
    def eventType: zio.aws.cloudfront.model.EventType
    def getFunctionARN: ZIO[Any, Nothing, FunctionARN] =
      ZIO.succeed(functionARN)
    def getEventType: ZIO[Any, Nothing, zio.aws.cloudfront.model.EventType] =
      ZIO.succeed(eventType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionAssociation
  ) extends zio.aws.cloudfront.model.FunctionAssociation.ReadOnly {
    override val functionARN: FunctionARN =
      zio.aws.cloudfront.model.primitives.FunctionARN(impl.functionARN())
    override val eventType: zio.aws.cloudfront.model.EventType =
      zio.aws.cloudfront.model.EventType.wrap(impl.eventType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FunctionAssociation
  ): zio.aws.cloudfront.model.FunctionAssociation.ReadOnly = new Wrapper(impl)
}
