package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.EventType
  ): zio.aws.cloudfront.model.EventType = value match {
    case software.amazon.awssdk.services.cloudfront.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.EventType.VIEWER_REQUEST =>
      val r = `viewer-request`
      r
    case software.amazon.awssdk.services.cloudfront.model.EventType.VIEWER_RESPONSE =>
      val r = `viewer-response`
      r
    case software.amazon.awssdk.services.cloudfront.model.EventType.ORIGIN_REQUEST =>
      val r = `origin-request`
      r
    case software.amazon.awssdk.services.cloudfront.model.EventType.ORIGIN_RESPONSE =>
      val r = `origin-response`
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudfront.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.EventType =
      software.amazon.awssdk.services.cloudfront.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object `viewer-request` extends zio.aws.cloudfront.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.EventType =
      software.amazon.awssdk.services.cloudfront.model.EventType.VIEWER_REQUEST
  }
  case object `viewer-response` extends zio.aws.cloudfront.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.EventType =
      software.amazon.awssdk.services.cloudfront.model.EventType.VIEWER_RESPONSE
  }
  case object `origin-request` extends zio.aws.cloudfront.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.EventType =
      software.amazon.awssdk.services.cloudfront.model.EventType.ORIGIN_REQUEST
  }
  case object `origin-response` extends zio.aws.cloudfront.model.EventType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.EventType =
      software.amazon.awssdk.services.cloudfront.model.EventType.ORIGIN_RESPONSE
  }
}
