package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait CertificateSource {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.CertificateSource
}
object CertificateSource {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.CertificateSource
  ): zio.aws.cloudfront.model.CertificateSource = value match {
    case software.amazon.awssdk.services.cloudfront.model.CertificateSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.CertificateSource.CLOUDFRONT =>
      val r = cloudfront
      r
    case software.amazon.awssdk.services.cloudfront.model.CertificateSource.IAM =>
      val r = iam
      r
    case software.amazon.awssdk.services.cloudfront.model.CertificateSource.ACM =>
      val r = acm
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.CertificateSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CertificateSource =
      software.amazon.awssdk.services.cloudfront.model.CertificateSource.UNKNOWN_TO_SDK_VERSION
  }
  case object cloudfront extends zio.aws.cloudfront.model.CertificateSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CertificateSource =
      software.amazon.awssdk.services.cloudfront.model.CertificateSource.CLOUDFRONT
  }
  case object iam extends zio.aws.cloudfront.model.CertificateSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CertificateSource =
      software.amazon.awssdk.services.cloudfront.model.CertificateSource.IAM
  }
  case object acm extends zio.aws.cloudfront.model.CertificateSource {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CertificateSource =
      software.amazon.awssdk.services.cloudfront.model.CertificateSource.ACM
  }
}
