package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InvalidationBatch(
    paths: zio.aws.cloudfront.model.Paths,
    callerReference: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.InvalidationBatch = {
    import InvalidationBatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.InvalidationBatch
      .builder()
      .paths(paths.buildAwsValue())
      .callerReference(callerReference: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.InvalidationBatch.ReadOnly =
    zio.aws.cloudfront.model.InvalidationBatch.wrap(buildAwsValue())
}
object InvalidationBatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.InvalidationBatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.InvalidationBatch =
      zio.aws.cloudfront.model
        .InvalidationBatch(paths.asEditable, callerReference)
    def paths: zio.aws.cloudfront.model.Paths.ReadOnly
    def callerReference: String
    def getPaths: ZIO[Any, Nothing, zio.aws.cloudfront.model.Paths.ReadOnly] =
      ZIO.succeed(paths)
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.InvalidationBatch
  ) extends zio.aws.cloudfront.model.InvalidationBatch.ReadOnly {
    override val paths: zio.aws.cloudfront.model.Paths.ReadOnly =
      zio.aws.cloudfront.model.Paths.wrap(impl.paths())
    override val callerReference: String = impl.callerReference(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.InvalidationBatch
  ): zio.aws.cloudfront.model.InvalidationBatch.ReadOnly = new Wrapper(impl)
}
